/* 
 * limit-cpu.c 
 *
 * Зменшує обмеження на споживання процесорного часу і входить у 
 * безкінечний цикл.
 * Ілюструє порядок застосування функцій getrlimit(), setrlimit().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/resource.h>


int main(void)
{
        struct rlimit r;

        /* Отримує діюче обмеження на споживання процесорного часу. */
        if (getrlimit(RLIMIT_CPU, &r) != 0) {
                fprintf(stderr, "Error getting limit for RLIMIT_CPU:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Зменшує обмеження на споживання процесорного часу
           до 1 секунди. */
        r.rlim_cur = 1;
        if (setrlimit(RLIMIT_CPU, &r) != 0) {
                fprintf(stderr, "Error setting limit for RLIMIT_CPU:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Входить у безкінечний цикл */
        while (1);

        exit(EXIT_SUCCESS);
}
